<?php

/*
 *  Para acceder al valor que tiene un array, utilizamos []  Ej: idUsuario = array["id"]
 *  Para acceder al valor de un objeto, utilizamos -> Ej: idUsuario = xml->usuario->id
 */

function devolverJSON() 
{
    $archivo = fopen("logAlbaranes.txt","a+");
    $start_time = microtime(true); // Marca de tiempo inicial

    $ip_cliente = $_GET['ip_cliente'];
    $puerto_cliente = $_GET['puerto_cliente'];
    $api_url = $ip_cliente . ":" . $puerto_cliente;
    $sid = $_GET['sid'];

    $params = array(
        "acc" => "lisenvios",
        "sid" => $sid
    );

    if (count($params) > 0) {
        $paramsurl = http_build_query($params, '', '&', PHP_QUERY_RFC3986);
    }

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $paramsurl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_URL, "http://$api_url/cgi-bin/conector_appDriver");

    $curl_start_time = time(); // Marca de tiempo después de configurar cURL

    $url = curl_exec($ch);

    $curl_end_time = time(); // Marca de tiempo después de completar la solicitud cURL
    $diff = $curl_end_time - $curl_start_time;

    //fwrite($archivo, 'segundos curl: '.$diff.PHP_EOL);

    $curl_start_time = time();
    $xml_obj = simplexml_load_string($url);
    $curl_end_time = time(); // Marca de tiempo después de completar la solicitud cURL
    $diff = $curl_end_time - $curl_start_time;
    //fwrite($archivo, 'segundos xml: '.$diff.PHP_EOL);

    $decode_start_time = microtime(true); // Marca de tiempo después de cargar XML y antes de la decodificación JSON

    $array = json_decode(json_encode($xml_obj->lisenvios), true);
    //fwrite($archivo,print_r($array,true).PHP_EOL);

    $decode_end_time = microtime(true); // Marca de tiempo después de la decodificación JSON

    $result = '';

    foreach ($array as $k) {
        $result = json_encode($k);
        header('Content-Type: application/json');
        header('Access-Control-Allow-Origin: *');
    }
    //fwrite($archivo,print_r($result,true).PHP_EOL);

    $foreach_end_time = microtime(true); // Marca de tiempo después del bucle foreach

    $end_time = microtime(true); // Marca de tiempo final
    $tiempo=  "Tiempo de cURL: " . ($curl_end_time - $curl_start_time) / 60 . " minutos<br> Tiempo de decodificación JSON: " . ($decode_end_time - $decode_start_time) / 60 . " minutos<br> Tiempo del bucle foreach: " . ($foreach_end_time - $decode_end_time) / 60 . " minutos<br> Tiempo de ejecución total: " . ($end_time - $start_time) / 60 . " minutos"; // Calcula el tiempo total
    // Decodificar el JSON object directamente en un JSON array
    fwrite($archivo,$result.PHP_EOL);
   
    echo $result;
}

devolverJSON();

?>
